<?php
require 'auth.php';
require 'config.php';

$stmt = $pdo->query("SELECT * FROM products ORDER BY id DESC");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة المنتجات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="dashboard.php">Supermarket QR</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link active" href="products.php">المنتجات</a></li>
        <li class="nav-item"><a class="nav-link" href="import_csv.php">استيراد CSV</a></li>
      </ul>
      <a href="logout.php" class="btn btn-outline-light btn-sm">خروج</a>
    </div>
  </div>
</nav>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>المنتجات</h3>
        <a href="product_form.php" class="btn btn-primary">+ إضافة منتج جديد</a>
    </div>
    <div class="table-responsive">
    <table class="table table-striped table-bordered">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>الكود (QR)</th>
                <th>الاسم</th>
                <th>السعر</th>
                <th>الصورة</th>
                <th>تحكم</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($products as $p): ?>
            <tr>
                <td><?php echo $p['id']; ?></td>
                <td><?php echo htmlspecialchars($p['code']); ?></td>
                <td><?php echo htmlspecialchars($p['name']); ?></td>
                <td><?php echo $p['price']; ?></td>
                <td>
                    <?php if ($p['image']): ?>
                        <img src="<?php echo htmlspecialchars($p['image']); ?>" alt="img" style="width:60px;height:60px;object-fit:cover;">
                    <?php endif; ?>
                </td>
                <td>
                    <a href="product_form.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-warning">تعديل</a>
                    <a href="product_delete.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-danger"
                       onclick="return confirm('هل أنت متأكد من الحذف؟');">حذف</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>
</body>
</html>
