<?php
require 'auth.php';
require 'config.php';

$id = $_GET['id'] ?? null;
$product = [
    'id' => '',
    'code' => '',
    'name' => '',
    'price' => '',
    'image' => ''
];

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$product) {
        die("المنتج غير موجود");
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title><?php echo $id ? "تعديل منتج" : "إضافة منتج"; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="dashboard.php">Supermarket QR</a>
  </div>
</nav>
<div class="container mt-4">
    <h3><?php echo $id ? "تعديل منتج" : "إضافة منتج"; ?></h3>
    <form method="post" action="product_save.php">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($product['id']); ?>">

        <div class="mb-3">
            <label class="form-label">الكود (الموجود في QR)</label>
            <input type="text" name="code" class="form-control" value="<?php echo htmlspecialchars($product['code']); ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">اسم المنتج</label>
            <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($product['name']); ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">السعر</label>
            <input type="number" step="0.01" name="price" class="form-control" value="<?php echo htmlspecialchars($product['price']); ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">رابط الصورة (URL) أو مسارها</label>
            <input type="text" name="image" class="form-control" value="<?php echo htmlspecialchars($product['image']); ?>">
        </div>
        <button class="btn btn-success">حفظ</button>
        <a href="products.php" class="btn btn-secondary">رجوع</a>
    </form>
</div>
</body>
</html>
