<?php
require '../config.php';
header('Content-Type: application/json; charset=utf-8');

$code = $_GET['code'] ?? '';
if (!$code) {
    echo json_encode(['success' => false, 'message' => 'code is required']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM products WHERE code = ?");
$stmt->execute([$code]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if ($product) {
    echo json_encode([
        'success' => true,
        'product' => [
            'id'    => (int)$product['id'],
            'code'  => $product['code'],
            'name'  => $product['name'],
            'price' => (float)$product['price'],
            'image' => $product['image']
        ]
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'product not found']);
}
?>
