CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO users (username, password)
SELECT 'admin', MD5('admin123')
WHERE NOT EXISTS (SELECT 1 FROM users WHERE username='admin');

CREATE TABLE IF NOT EXISTS products (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(100) UNIQUE NOT NULL,
    name VARCHAR(255) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    description TEXT NULL,
    image VARCHAR(255) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS scans (
    id INT AUTO_INCREMENT PRIMARY KEY,
    product_id INT NULL,
    code VARCHAR(100),
    device_id VARCHAR(100),
    scan_name VARCHAR(255) NULL,
    scan_price DECIMAL(10,2) NULL,
    scanned_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE SET NULL
);

CREATE TABLE IF NOT EXISTS settings (
    `key` VARCHAR(100) PRIMARY KEY,
    `value` TEXT
);

INSERT INTO settings(`key`, `value`) 
SELECT 'default_image', '/uploads/products/default.png'
WHERE NOT EXISTS (SELECT 1 FROM settings WHERE `key`='default_image');

INSERT INTO settings(`key`, `value`) 
SELECT 'offline_enabled', '1'
WHERE NOT EXISTS (SELECT 1 FROM settings WHERE `key`='offline_enabled');

INSERT INTO settings(`key`, `value`) 
SELECT 'offline_token', 'MY_OFFLINE_TOKEN'
WHERE NOT EXISTS (SELECT 1 FROM settings WHERE `key`='offline_token');
