<?php
require 'auth.php';
require 'config.php';

// جلب الإعدادات الحالية
$settings = [];
$stmt = $pdo->query("SELECT `key`,`value` FROM settings");
foreach ($stmt as $row) {
    $settings[$row['key']] = $row['value'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $default_image   = $_POST['default_image'] ?? '/uploads/products/default.png';
    $offline_enabled = isset($_POST['offline_enabled']) ? '1' : '0';
    $offline_token   = $_POST['offline_token'] ?? 'MY_OFFLINE_TOKEN';

    $pairs = [
        'default_image'   => $default_image,
        'offline_enabled' => $offline_enabled,
        'offline_token'   => $offline_token
    ];

    foreach ($pairs as $k => $v) {
        $stmt = $pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?)
            ON DUPLICATE KEY UPDATE `value`=VALUES(`value`)");
        $stmt->execute([$k, $v]);
    }

    header("Location: settings.php");
    exit;
}

$default_image   = $settings['default_image']   ?? '/uploads/products/default.png';
$offline_enabled = ($settings['offline_enabled'] ?? '1') === '1';
$offline_token   = $settings['offline_token']   ?? 'MY_OFFLINE_TOKEN';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>الإعدادات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand" href="dashboard.php">Supermarket QR</a>
  </div>
</nav>
<div class="container mt-4">
    <h3>الإعدادات العامة</h3>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">مسار الصورة الافتراضية للمنتجات (بدون صورة)</label>
            <input type="text" name="default_image" class="form-control"
                   value="<?php echo htmlspecialchars($default_image); ?>">
            <div class="form-text">مثال: /uploads/products/default.png</div>
        </div>
        <div class="mb-3">
            <label class="form-label">OFFLINE TOKEN لتصدير قاعدة البيانات</label>
            <input type="text" name="offline_token" class="form-control"
                   value="<?php echo htmlspecialchars($offline_token); ?>">
            <div class="form-text">
                يجب أن يطابق هذا التوكن في تطبيق الأندرويد.<br>
                رابط API:
                /api/offline_products.php?token=OFFLINE_TOKEN
            </div>
        </div>
        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" id="offline_enabled" name="offline_enabled"
                <?php if ($offline_enabled) echo 'checked'; ?>>
            <label class="form-check-label" for="offline_enabled">
                تفعيل تصدير قاعدة البيانات للأوفلاين
            </label>
        </div>
        <button class="btn btn成功">حفظ الإعدادات</button>
        <a href="dashboard.php" class="btn btn-secondary">رجوع</a>
    </form>
</div>
</body>
</html>
