<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'auth.php';
require 'config.php';

// جلب الإعدادات
$stmt = $pdo->prepare("SELECT value FROM settings WHERE `key`='default_image'");
$stmt->execute();
$default_image = $stmt->fetchColumn() ?: '/uploads/products/default.png';

$id          = $_POST['id'] ?? null;
$code        = $_POST['code'] ?? '';
$name        = $_POST['name'] ?? '';
$price       = $_POST['price'] ?? 0;
$description = $_POST['description'] ?? '';
$image_path  = null;

// لو تعديل — جب الصورة القديمة
if ($id) {
    $stmt = $pdo->prepare("SELECT image FROM products WHERE id=?");
    $stmt->execute([$id]);
    $image_old = $stmt->fetchColumn();
    $image_path = $image_old ?: $default_image;
} else {
    $image_path = $default_image;
}

// رفع صورة جديدة لو موجودة
if (!empty($_FILES['image_file']['name']) &&
    $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {

    $folder = __DIR__ . "/uploads/products/";
    if (!is_dir($folder)) mkdir($folder, 0777, true);

    $ext = pathinfo($_FILES['image_file']['name'], PATHINFO_EXTENSION);
    $new_name = "P_" . uniqid() . "." . strtolower($ext);

    $destination = $folder . $new_name;
    move_uploaded_file($_FILES['image_file']['tmp_name'], $destination);

    // مسار قابل للوصول من المتصفح
    $image_path = "/uploads/products/" . $new_name;
}

if ($id) {
    // تعديل
    $stmt = $pdo->prepare("
        UPDATE products SET
        code=?, name=?, price=?, description=?, image=?
        WHERE id=?
    ");
    $stmt->execute([$code, $name, $price, $description, $image_path, $id]);
} else {
    // إضافة
    $stmt = $pdo->prepare("
        INSERT INTO products (code, name, price, description, image)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$code, $name, $price, $description, $image_path]);
}

header("Location: products.php");
exit;
?>
