<?php
require 'auth.php';
require 'config.php';

// جلب الصورة الافتراضية من الإعدادات
$stmt = $pdo->prepare("SELECT value FROM settings WHERE `key`='default_image'");
$stmt->execute();
$default_image = $stmt->fetchColumn() ?: '/uploads/products/default.png';

$id = $_GET['id'] ?? null;
$product = [
    'id' => '',
    'code' => '',
    'name' => '',
    'price' => '',
    'description' => '',
    'image' => ''
];

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
    $stmt->execute([$id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title><?php echo $id ? 'تعديل المنتج' : 'إضافة منتج'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow p-4">
        <h3><?php echo $id ? 'تعديل المنتج' : 'إضافة منتج جديد'; ?></h3>
        <hr>

        <form method="post" action="product_save.php" enctype="multipart/form-data">

            <input type="hidden" name="id" value="<?php echo $product['id']; ?>">

            <div class="mb-3">
                <label class="form-label">الكود (QR)</label>
                <input type="text" name="code" class="form-control"
                       value="<?php echo htmlspecialchars($product['code']); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">اسم المنتج</label>
                <input type="text" name="name" class="form-control"
                       value="<?php echo htmlspecialchars($product['name']); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">السعر (ليرة سورية)</label>
                <input type="number" name="price" class="form-control" step="0.01"
                       value="<?php echo htmlspecialchars($product['price']); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">وصف المنتج</label>
                <textarea name="description" class="form-control" rows="4"><?php
                    echo htmlspecialchars($product['description']);
                ?></textarea>
            </div>

            <div class="mb-3">
                <label class="form-label">صورة المنتج</label>
                <input type="file" name="image_file" class="form-control" accept="image/*">

                <?php if (!empty($product['image'])): ?>
                    <div class="mt-3">
                        <p class="text-muted">الصورة الحالية:</p>
                        <img src="<?php echo $product['image']; ?>"
                             style="width:120px;height:120px;object-fit:cover;border-radius:10px;">
                    </div>
                <?php else: ?>
                    <p class="text-muted mt-2">لا توجد صورة - سيتم استخدام الصورة الافتراضية</p>
                <?php endif; ?>
            </div>

            <button class="btn btn-primary px-4">حفظ</button>
            <a href="products.php" class="btn btn-secondary">رجوع</a>
        </form>
    </div>
</div>
</body>
</html>
