<?php
require '../config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data['logs'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

$logs = $data['logs'];
$inserted = 0;

foreach ($logs as $log) {

    $code      = $log['code'] ?? '';
    $name      = $log['name'] ?? '';
    $price     = $log['price'] ?? 0;
    $device_id = $log['device_id'] ?? '';
    $date      = $log['date'] ?? '';

    $stmt = $pdo->prepare("
        INSERT INTO scans (code, scan_name, scan_price, device_id, scanned_at)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$code, $name, $price, $device_id, $date]);

    $inserted++;
}

echo json_encode(['success' => true, 'inserted' => $inserted]);
?>
