<?php
require '../config.php';
header('Content-Type: application/json');

$code = $_GET['code'] ?? '';
$code = trim($code); // ← مهم جداً

if (!$code) {
    echo json_encode(['success' => false, 'message' => 'No code provided']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM products WHERE code=?");
$stmt->execute([$code]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$product) {
    echo json_encode(['success' => false, 'message' => 'Product not found', 'code' => $code]);
    exit;
}

echo json_encode([
    'success' => true,
    'product' => $product
]);
?>
